package ru.yandex.direct.tracing.data;

import java.io.IOException;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

@JsonSerialize(using = TraceDataAnnotation.Serializer.class)
public class TraceDataAnnotation {
    private String key;
    private String value;

    public TraceDataAnnotation(String key, String value) {
        this.key = key;
        this.value = value;
    }

    public String getKey() {

        return key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public static class Serializer extends JsonSerializer<TraceDataAnnotation> {
        @Override
        public void serialize(TraceDataAnnotation annotation, JsonGenerator gen, SerializerProvider serializers)
                throws IOException, JsonProcessingException {
            gen.writeStartArray();
            gen.writeString(annotation.getKey());
            gen.writeString(annotation.getValue());
            gen.writeEndArray();
        }
    }

    public static class Deserializer extends JsonDeserializer<TraceDataAnnotation> {
        @Override
        public TraceDataAnnotation deserialize(
                JsonParser p, DeserializationContext ctxt
        ) throws IOException, JsonProcessingException {
            JsonParserHelper ph = new JsonParserHelper(p);

            return ph.readArray(() ->
                    new TraceDataAnnotation(ph.nextString(), ph.nextString())
            );
        }
    }

}
