package ru.yandex.direct.tracing.data;

import java.io.IOException;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.MoreObjects;

@JsonSerialize(using = TraceDataChild.Serializer.class)
public class TraceDataChild {
    private String service;
    private String method;
    private long spanId;
    private double relativeStartInstant;
    private double ela;

    public TraceDataChild(String service, String method, long spanId, double relativeStartInstant, double ela) {
        this.service = service;
        this.method = method;
        this.spanId = spanId;
        this.relativeStartInstant = relativeStartInstant;
        this.ela = ela;
    }

    public String getService() {
        return service;
    }

    public void setService(String service) {
        this.service = service;
    }

    public String getMethod() {
        return method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public long getSpanId() {
        return spanId;
    }

    public void setSpanId(long spanId) {
        this.spanId = spanId;
    }

    public double getRelativeStartInstant() {
        return relativeStartInstant;
    }

    public void setRelativeStartInstant(double relativeStartInstant) {
        this.relativeStartInstant = relativeStartInstant;
    }

    public double getEla() {
        return ela;
    }

    public void setEla(double ela) {
        this.ela = ela;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("service", service)
                .add("method", method)
                .add("spanId", spanId)
                .add("relativeStartInstant", relativeStartInstant)
                .add("ela", ela)
                .toString();
    }

    public static class Serializer extends JsonSerializer<TraceDataChild> {
        @Override
        public void serialize(TraceDataChild child, JsonGenerator gen, SerializerProvider serializers)
                throws IOException, JsonProcessingException {
            gen.writeStartArray();
            gen.writeString(child.getService());
            gen.writeString(child.getMethod());
            gen.writeNumber(child.getSpanId());
            gen.writeNumber(child.getRelativeStartInstant());
            gen.writeNumber(child.getEla());
            gen.writeEndArray();
        }
    }

    public static class Deserializer extends JsonDeserializer<TraceDataChild> {
        @Override
        public TraceDataChild deserialize(
                JsonParser p, DeserializationContext ctxt
        ) throws IOException, JsonProcessingException {
            JsonParserHelper ph = new JsonParserHelper(p);

            return ph.readArray(() ->
                    new TraceDataChild(
                            ph.nextString(), ph.nextString(),
                            ph.nextLong(),
                            ph.nextDouble(), ph.nextDouble()
                    )
            );
        }
    }
}
