package ru.yandex.direct.tracing.data;

import java.io.IOException;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.MoreObjects;

@JsonSerialize(using = TraceDataMark.Serializer.class)
public class TraceDataMark {
    private double relativeInstant;
    private String message;

    public TraceDataMark(double relativeInstant, String message) {
        this.relativeInstant = relativeInstant;
        this.message = message;
    }

    public double getRelativeInstant() {
        return relativeInstant;
    }

    public void setRelativeInstant(double relativeInstant) {
        this.relativeInstant = relativeInstant;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("relativeInstant", relativeInstant)
                .add("message", message)
                .toString();
    }

    public static class Serializer extends JsonSerializer<TraceDataMark> {
        @Override
        public void serialize(TraceDataMark mark, JsonGenerator gen, SerializerProvider serializers)
                throws IOException, JsonProcessingException {
            gen.writeStartArray();
            gen.writeNumber(mark.getRelativeInstant());
            gen.writeString(mark.getMessage());
            gen.writeEndArray();
        }
    }

    public static class Deserializer extends JsonDeserializer<TraceDataMark> {
        @Override
        public TraceDataMark deserialize(
                JsonParser p, DeserializationContext ctxt
        ) throws IOException, JsonProcessingException {
            JsonParserHelper ph = new JsonParserHelper(p);

            return ph.readArray(() ->
                    new TraceDataMark(ph.nextDouble(), ph.nextString())
            );
        }
    }

}
