package ru.yandex.direct.tracing.data;

import java.io.IOException;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.MoreObjects;

@JsonSerialize(using = TraceDataProfile.Serializer.class)
public class TraceDataProfile {
    private String func;
    private String tags;
    private double allEla;
    private double childrenEla;
    private long calls;
    private long objCount;

    public TraceDataProfile(String func, String tags) {
        this.func = func;
        this.tags = tags;
    }

    public TraceDataProfile(String func, String tags, double allEla, double childrenEla, long calls, long objCount) {
        this.func = func;
        this.tags = tags;
        this.allEla = allEla;
        this.childrenEla = childrenEla;
        this.calls = calls;
        this.objCount = objCount;
    }

    public String getFunc() {
        return func;
    }

    public void setFunc(String func) {
        this.func = func;
    }

    public String getTags() {
        return tags;
    }

    public void setTags(String tags) {
        this.tags = tags;
    }

    public double getAllEla() {
        return allEla;
    }

    public void setAllEla(double allEla) {
        this.allEla = allEla;
    }

    public double getChildrenEla() {
        return childrenEla;
    }

    public void setChildrenEla(double childrenEla) {
        this.childrenEla = childrenEla;
    }

    public long getCalls() {
        return calls;
    }

    public void setCalls(long calls) {
        this.calls = calls;
    }

    public long getObjCount() {
        return objCount;
    }

    public void setObjCount(long objCount) {
        this.objCount = objCount;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("func", func)
                .add("tags", tags)
                .add("allEla", allEla)
                .add("childrenEla", childrenEla)
                .add("calls", calls)
                .add("objCount", objCount)
                .toString();
    }

    public static class Serializer extends JsonSerializer<TraceDataProfile> {
        @Override
        public void serialize(TraceDataProfile profile, JsonGenerator gen, SerializerProvider serializers)
                throws IOException, JsonProcessingException {
            gen.writeStartArray();
            gen.writeString(profile.getFunc());
            gen.writeString(profile.getTags());
            gen.writeNumber(profile.getAllEla());
            gen.writeNumber(profile.getChildrenEla());
            gen.writeNumber(profile.getCalls());
            gen.writeNumber(profile.getObjCount());
            gen.writeEndArray();
        }
    }

    public static class Deserializer extends JsonDeserializer<TraceDataProfile> {
        @Override
        public TraceDataProfile deserialize(
                JsonParser p, DeserializationContext ctxt
        ) throws IOException, JsonProcessingException {
            JsonParserHelper ph = new JsonParserHelper(p);

            return ph.readArray(() ->
                    new TraceDataProfile(
                            ph.nextString(), ph.nextString(),
                            ph.nextDouble(), ph.nextDouble(),
                            ph.nextLong(), ph.nextLong()
                    )
            );
        }
    }
}
