package ru.yandex.direct.tracing.data;

import java.io.IOException;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.MoreObjects;

import static com.google.common.base.Preconditions.checkArgument;

@JsonSerialize(using = TraceDataTimes.Serializer.class)
public class TraceDataTimes {
    private double ela;
    private double cpuUserTime;
    private double cpuSystemTime;
    private double mem;

    public TraceDataTimes() {
        // all default values
    }

    public TraceDataTimes(double ela, double cpuUserTime, double cpuSystemTime, double mem) {
        this.ela = ela;
        this.cpuUserTime = cpuUserTime;
        this.cpuSystemTime = cpuSystemTime;
        this.mem = mem;
    }

    public double getEla() {
        return ela;
    }

    public void setEla(double ela) {
        this.ela = ela;
    }

    public double getCpuUserTime() {
        return cpuUserTime;
    }

    public void setCpuUserTime(double cpuUserTime) {
        this.cpuUserTime = cpuUserTime;
    }

    public double getCpuSystemTime() {
        return cpuSystemTime;
    }

    public void setCpuSystemTime(double cpuSystemTime) {
        this.cpuSystemTime = cpuSystemTime;
    }

    public double getMem() {
        return mem;
    }

    public void setMem(double mem) {
        this.mem = mem;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("ela", ela)
                .add("cpuUserTime", cpuUserTime)
                .add("cpuSystemTime", cpuSystemTime)
                .add("mem", mem)
                .toString();
    }

    public static class Serializer extends JsonSerializer<TraceDataTimes> {
        @Override
        public void serialize(TraceDataTimes times, JsonGenerator gen, SerializerProvider serializers)
                throws IOException, JsonProcessingException {
            gen.writeStartObject();
            gen.writeNumberField("ela", times.getEla());
            gen.writeNumberField("cu", times.getCpuUserTime());
            gen.writeNumberField("cs", times.getCpuSystemTime());
            gen.writeNumberField("mem", times.getMem());
            gen.writeEndObject();
        }
    }

    public static class Deserializer extends JsonDeserializer<TraceDataTimes> {
        @Override
        public TraceDataTimes deserialize(
                JsonParser p, DeserializationContext ctxt
        ) throws IOException, JsonProcessingException {
            JsonParserHelper ph = new JsonParserHelper(p);

            TraceDataTimes times = new TraceDataTimes();
            checkArgument(p.currentToken() == JsonToken.START_OBJECT, "incorrect current token: " + p.currentToken());
            while (p.nextToken() != JsonToken.END_OBJECT) {
                switch (p.getCurrentName()) {
                    case "ela":
                        times.setEla(ph.nextDouble());
                        break;
                    case "cu":
                        times.setCpuUserTime(ph.nextDouble());
                        break;
                    case "cs":
                        times.setCpuSystemTime(ph.nextDouble());
                        break;
                    case "mem":
                        times.setMem(ph.nextDouble());
                        break;
                    default:
                        // skip
                        ph.nextTree();
                }
            }
            return times;
        }
    }

}
