package ru.yandex.direct.tracing.util;

import java.net.InetAddress;
import java.net.UnknownHostException;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostnameUtils {
    private static final Logger logger = LoggerFactory.getLogger(HostnameUtils.class);

    private HostnameUtils() {
    }

    private static volatile String hostname = null;

    public static String hostname() {
        if (hostname == null) {
            // не заботимся о конкуррентном выполнении
            hostname = systemHostname();
        }
        return hostname;
    }

    private static String systemHostname() {
        try {
            // We call toLowerCase as a workaround for DNS servers that cache domain names with whatever case
            // it was in the query. It has been known to return names like YaNDEX.net on OpenStack.
            return InetAddress.getLocalHost().getCanonicalHostName().toLowerCase();
        } catch (UnknownHostException exc) {
            return "localhost";
        }
    }
}
