package ru.yandex.direct.tracing.util;

/**
 * Provides cpu time for any thread. For performance reasons thread's allocated memory is not measured
 */
public class ThreadUsedCpuTimeProvider extends ThreadUsedResourcesProvider {
    private static final ThreadUsedCpuTimeProvider INSTANCE = new ThreadUsedCpuTimeProvider();

    @Override
    protected long getCurrentThreadAllocatedBytes() {
        return 0L;
    }

    @Override
    protected long getThreadAllocatedBytes(Thread thread) {
        return 0L;
    }

    public static ThreadUsedCpuTimeProvider instance() {
        return INSTANCE;
    }
}
