package ru.yandex.direct.tracing.util;

/**
 * Потраченное cpu-time
 */
public class ThreadUsedResources {
    private final long userTime;
    private final long cpuTime;
    private final long allocatedBytes;

    public ThreadUsedResources(long userTime, long cpuTime, long allocatedBytes) {
        this.userTime = userTime;
        this.cpuTime = cpuTime;
        this.allocatedBytes = allocatedBytes;
    }

    /**
     * Returns total cpu time
     */
    public long getCpuTime() {
        return cpuTime;
    }

    /**
     * Returns user cpu time
     */
    public long getUserTime() {
        return userTime;
    }

    /**
     * Returns system cpu time
     */
    public long getSystemTime() {
        return cpuTime - userTime;
    }

    /**
     * Возвращает приблизительное количество байт, выделенных потоком нв хипе
     */
    public long getAllocatedBytes() {
        return allocatedBytes;
    }

    /**
     * В объекте содержатся реальные данные о cpu, а не -1 (CPU time measurement is disabled или UnsupportedOperation)
     */
    public boolean isReliableCpuTimes() {
        return cpuTime >= 0 && userTime >= 0;
    }

    /**
     * В объекте содержатся реальные данные о аллоцированной памяти
     */
    public boolean isReliableAllocationInfo() {
        return allocatedBytes >= 0;
    }
}
