package ru.yandex.direct.tracing.util;

import java.time.Clock;
import java.time.Instant;

/**
 * Used primarily for mocking time-related functions
 */
public interface TraceClockProvider {
    /**
     * Returns current time usable for measuring elapsed time, in nanoseconds
     */
    long nanoTime();

    /**
     * Returns current time usable for printing in a log file
     */
    Instant instant();

    /**
     * Default implementation for TraceClockProvider
     */
    final class Default implements TraceClockProvider {
        private static final Default INSTANCE = new Default();
        private final Clock clock;

        public Default() {
            this(Clock.systemUTC());
        }

        public Default(Clock clock) {
            this.clock = clock;
        }

        @Override
        public long nanoTime() {
            return System.nanoTime();
        }

        @Override
        public Instant instant() {
            return clock.instant();
        }

        public static Default instance() {
            return INSTANCE;
        }
    }

}

