package ru.yandex.direct.tracing.util;

import java.util.HashMap;
import java.util.Map;

import com.google.common.base.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Class containing variables for sql query comment used in {@link TraceUtil#getTraceSqlComment()}
 */
public class TraceCommentVars {
    private static final Logger logger = LoggerFactory.getLogger(TraceCommentVars.class);

    public static final String OPERATOR_FIELD = "operator";

    public static final String PAGE_REQID_FIELD = "pageReqid";

    public static final String PAGE_CMD_FIELD = "pageCmd";

    /**
     * Http-header containing trace comment vars
     */
    public static final String X_YANDEX_TRACE_COMMENT_VARS = "X-Yandex-Trace-Comment-Vars";

    // https://st.yandex-team.ru/DIRECT-151113
    public static final String X_PAGE_INFO = "X-Page-Info";

    private Map<String, String> map;

    public TraceCommentVars() {
        map = new HashMap<>();
    }

    public TraceCommentVars(Map<String, String> map) {
        this.map = map;
    }

    public String getOperator() {
        return map.get(OPERATOR_FIELD);
    }

    public void setOperator(String value) {
        map.put(OPERATOR_FIELD, value);
    }

    public void removeOperator() {
        map.remove(OPERATOR_FIELD);
    }

    public void setPageReqid(String value) { map.put(PAGE_REQID_FIELD, value); }

    public void removePageReqid() {
        map.remove(PAGE_REQID_FIELD);
    }

    public void setPageCmd(String value) { map.put(PAGE_CMD_FIELD, value); }

    public void removePageCmd() {
        map.remove(PAGE_CMD_FIELD);
    }

    public void addTags(Map<String, String> tags) {
        map.putAll(tags);
    }

    public Map<String, String> getMap() {
        return map;
    }

    public static Map<String, String> parseHeader(String header) {
        Map<String, String> result = new HashMap<>();
        if (!Strings.isNullOrEmpty(header)) {
            for (String item : header.split(",")) {
                String[] parts = item.split("=", 2);
                if (parts.length == 2) {
                    result.put(parts[0], parts[1]);
                } else {
                    logger.warn("Invalid TraceCommentVars header part {}", item);
                }
            }
        }
        return result;
    }

    public static Map<String, String> parsePageInfoHeader(String header) {
        Map<String, String> result = new HashMap<>();
        if (!Strings.isNullOrEmpty(header)) {
            for (String item : header.split(",")) {
                String[] parts = item.split(":", 2);
                if (parts.length == 2) {
                    if (parts[0].equals("reqid")) {
                        result.put(PAGE_REQID_FIELD, parts[1]);
                    } else if (parts[0].equals("cmd")) {
                        result.put(PAGE_CMD_FIELD, parts[1]);
                    }
                } else {
                    logger.warn("Invalid X-Page-Info header part {}", item);
                }
            }
        }
        return result;
    }
}
