package ru.yandex.direct.tracing.util;

import javax.annotation.Nonnull;

/**
 * Holds {@link TraceCommentVars} for sql query comment in {@link TraceUtil#getTraceSqlComment()}.
 */
public class TraceCommentVarsHolder {
    private static ThreadLocal<TraceCommentVars> traceCommentVars = new ThreadLocal<>();

    private TraceCommentVarsHolder() {
    }

    /**
     * Get trace comment vars
     */
    @Nonnull
    public static TraceCommentVars get() {
        TraceCommentVars currentValue = traceCommentVars.get();
        if (currentValue == null) {
            currentValue = new TraceCommentVars();
            set(currentValue);
        }
        return currentValue;
    }

    /**
     * Set trace comment vars
     */
    public static void set(TraceCommentVars value) {
        traceCommentVars.set(value);
    }
}
