package ru.yandex.direct.transfermanagerutils;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Модель конфига для клиента к ТМ
 */
@ParametersAreNonnullByDefault
public class TransferManagerJobConfig {
    @JsonProperty("input_cluster")
    private String inputCluster;

    @JsonProperty("output_cluster")
    private String outputCluster;

    @JsonProperty("input_table")
    private String inputTable;

    @JsonProperty("ouput_table")
    private String outputTable;

    public TransferManagerJobConfig(
            @JsonProperty("input_cluster") String inputCluster,
            @JsonProperty("output_cluster") String outputCluster,
            @JsonProperty("input_table") String inputTable,
            @JsonProperty("ouput_table") String outputTable) {
        this.inputCluster = inputCluster;
        this.outputCluster = outputCluster;
        this.inputTable = inputTable;
        this.outputTable = outputTable;
    }

    public TransferManagerJobConfig() {
    }

    public TransferManagerJobConfig withInputCluster(String inputCluster) {
        this.inputCluster = inputCluster;
        return this;
    }

    public TransferManagerJobConfig withOutputCluster(String outputCluster) {
        this.outputCluster = outputCluster;
        return this;
    }

    public TransferManagerJobConfig withInputTable(String inputTable) {
        this.inputTable = inputTable;
        return this;
    }

    public TransferManagerJobConfig withOutputTable(String outputTable) {
        this.outputTable = outputTable;
        return this;
    }

    public String getInputCluster() {
        if (inputCluster == null) {
            throw new TransferManagerConfigurationException("Field inputCluster was not initialized");
        }
        return inputCluster;
    }

    public String getOutputCluster() {
        if (outputCluster == null) {
            throw new TransferManagerConfigurationException("Field outputCluster was not initialized");
        }
        return outputCluster;
    }

    public String getInputTable() {
        if (inputTable == null) {
            throw new TransferManagerConfigurationException("Field inputTable was not initialized");
        }
        return inputTable;
    }

    public String getOutputTable() {
        if (outputTable == null) {
            throw new TransferManagerConfigurationException("Field outputTable was not initialized");
        }
        return outputTable;
    }
}
