package ru.yandex.direct.transfermanagerutils;

import org.apache.commons.lang3.RandomStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.retry.RetryCallback;
import org.springframework.retry.RetryContext;
import org.springframework.retry.RetryListener;

import ru.yandex.direct.utils.JsonUtils;

/**
 * Описание как ретраить в апи transfer manager:
 * <a href="https://wiki.yandex-team.ru/transfer-manager/copy/#ispolzovanijatransfermanagervavtomaticheskixprocessax">вики</a>
 */
class TransferManagerRetryListener implements RetryListener {

    private static final Logger logger = LoggerFactory.getLogger(TransferManagerRetryListener.class);

    private static final String TM_RETRY_CONTEXT_KEY = "tm.retry.context";

    private static final String X_TM_PARAMETERS = "X-TM-Parameters";

    @Override
    public <T, E extends Throwable> boolean open(RetryContext context, RetryCallback<T, E> callback) {
        var tmRetryContext = createRetryContext();
        context.setAttribute(TM_RETRY_CONTEXT_KEY, tmRetryContext);
        return true;
    }

    @Override
    public <T, E extends Throwable> void onError(RetryContext context, RetryCallback<T, E> callback,
                                                 Throwable throwable) {
        Object tmRetryContext = context.getAttribute(TM_RETRY_CONTEXT_KEY);
        if (tmRetryContext instanceof TransferManagerRetryContext) {
            ((TransferManagerRetryContext) tmRetryContext).setRetry(true);
        }
    }

    @Override
    public <T, E extends Throwable> void close(RetryContext context, RetryCallback<T, E> callback,
                                               Throwable throwable) {
    }

    private static TransferManagerRetryContext createRetryContext() {
        return new TransferManagerRetryContext(RandomStringUtils.randomAlphanumeric(20), false);
    }

    public static void fillRetryContextHeader(RetryContext context, HttpHeaders headers) {
        Object tmRetryContext = context.getAttribute(TM_RETRY_CONTEXT_KEY);
        if (tmRetryContext instanceof TransferManagerRetryContext) {
            headers.set(X_TM_PARAMETERS, JsonUtils.toJson(tmRetryContext));
        }
    }
}
