package ru.yandex.direct.transfermanagerutils;

import java.util.Arrays;
import java.util.Map;
import java.util.Optional;

import static java.util.function.Function.identity;
import static ru.yandex.direct.utils.FunctionalUtils.listToMap;

/**
 * Возможные состояния таски в TM. Взято из Python (transfer_manager_client_trunk)
 */
enum TransferManagerState {
    COMPLETED,
    SKIPPED,
    ABORTED,
    FAILED;

    private static Map<String, TransferManagerState> knownStatesMap =
            listToMap(Arrays.asList(TransferManagerState.values()), s -> s.name().toLowerCase(), identity());

    public static Optional<TransferManagerState> byName(String name) {
        return Optional.ofNullable(knownStatesMap.get(name));
    }
}
