package ru.yandex.direct.turbolandings.client;

import java.util.Collection;
import java.util.List;

import ru.yandex.direct.http.smart.annotations.Json;
import ru.yandex.direct.http.smart.core.Call;
import ru.yandex.direct.http.smart.http.Body;
import ru.yandex.direct.http.smart.http.GET;
import ru.yandex.direct.http.smart.http.Headers;
import ru.yandex.direct.http.smart.http.POST;
import ru.yandex.direct.http.smart.http.Query;
import ru.yandex.direct.turbolandings.client.model.GetIdByUrlResponseItem;
import ru.yandex.direct.turbolandings.client.model.GetTurboLandingsResponse;

public interface Api {
    @GET("/api/direct/landings")
    @Json
    Call<GetTurboLandingsResponse> getTurboLandings(@Query("client_id") Long clientId,
                                                    @Query("ids") String turboIds, @Query("limit") Integer limit,
                                                    @Query("offset") Integer offset);
    @POST("api/direct/getIdByUrl")
    @Json
    @Headers("Content-Type: application/json")
    Call<List<GetIdByUrlResponseItem>> getTurbolandingIdsByUrl(@Json @Body Collection<String> urls);
}
