package ru.yandex.direct.turbolandings.client;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import static com.google.common.base.Preconditions.checkArgument;
import static com.google.common.base.Strings.isNullOrEmpty;

/**
 * Конфигурация для клиента к DisplayCanvas
 */
public class TurboLandingsClientConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(TurboLandingsClient.class);

    private String url;
    private String token;

    public TurboLandingsClientConfiguration(String url, String token, String pathToTokenFile) {
        checkArgument(!isNullOrEmpty(url));
        this.url = url;
        if (token == null || token.isEmpty()) {
            token = getTokenFromFile(pathToTokenFile);
        }
        this.token = token;
    }

    public String getUrl() {
        return url;
    }

    public String getToken() {
        return token;
    }

    private static String getTokenFromFile(String filePath) {
        String token;
        try {
            token = Files.lines(Paths.get(filePath)).findFirst().orElse("");
        } catch (IOException e) {
            token = "";
            logger.error("Can't get token from file: {}", e.getMessage());
        }
        return token;
    }
}
