package ru.yandex.direct.turbopages.client;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonInclude(JsonInclude.Include.NON_NULL)
public class CheckUrlsResponse {

    @JsonProperty("original_url")
    private String originalUrl;

    @JsonProperty("turbo_url")
    private String turboUrl;

    public String getOriginalUrl() {
        return originalUrl;
    }

    public void setOriginalUrl(String originalUrl) {
        this.originalUrl = originalUrl;
    }

    public String getTurboUrl() {
        return turboUrl;
    }

    public void setTurboUrl(String turboUrl) {
        this.turboUrl = turboUrl;
    }

    public CheckUrlsResponse withOriginalUrl(String originalUrl) {
        setOriginalUrl(originalUrl);
        return this;
    }

    public CheckUrlsResponse withTurboUrl(String turboUrl) {
        setTurboUrl(turboUrl);
        return this;
    }

}
