package ru.yandex.direct.turbopages.client;

import java.util.List;
import java.util.Map;

import ru.yandex.direct.asynchttp.ParallelFetcherFactory;
import ru.yandex.direct.asynchttp.Result;
import ru.yandex.direct.http.smart.core.Smart;
import ru.yandex.direct.http.smart.error.ErrorUtils;

import static ru.yandex.direct.utils.FunctionalUtils.listToMap;

/**
 * Клиент для запроса в Турбо API
 *
 * Описание {@link https://wiki.yandex-team.ru/turbopages/backend/turboapi/}
 */
public class TurbopagesClient {

    // По умолчанию работаем с листингом товаров
    private final static boolean IS_LISTING = true;

    private Api api;

    public TurbopagesClient(TurbopagesClientConfiguration config, ParallelFetcherFactory parallelFetcherFactory) {
        api = createApi(config, parallelFetcherFactory);
    }

    private Api createApi(TurbopagesClientConfiguration config, ParallelFetcherFactory parallelFetcherFactory) {
        return Smart.builder()
                .withParallelFetcherFactory(parallelFetcherFactory)
                .addHeaderConfigurator(headers -> {
                    headers.add("Content-type", "application/json");
                    headers.add(TurbopagesClientConfiguration.X_YANDEX_TURBO_API_CLIENT, config.getHeader());
                })
                .withProfileName("turbopages.client")
                .withBaseUrl(config.getUrl())
                .build()
                .create(Api.class);
    }

    public Map<String, String> checkUrls(List<String> originalUrls) {
        Result<List<CheckUrlsResponse>> result = api.checkUrls(IS_LISTING, originalUrls).execute();
        ErrorUtils.checkResultForErrors(result, TurbopagesClientException::new);
        return convertToMap(result.getSuccess());
    }

    private Map<String, String> convertToMap(List<CheckUrlsResponse> list) {
        return listToMap(list, CheckUrlsResponse::getOriginalUrl, CheckUrlsResponse::getTurboUrl);
    }

}
