package ru.yandex.direct.turbopages.client;

import com.google.common.base.Preconditions;

import static com.google.common.base.Strings.isNullOrEmpty;

/**
 * Конфигурация для клиента к Турбо
 */
public class TurbopagesClientConfiguration {

    final static String X_YANDEX_TURBO_API_CLIENT = "X-Yandex-Turbo-Api-Client";

    private String url;

    private String header;

    public TurbopagesClientConfiguration(String url, String header) {
        Preconditions.checkArgument(!isNullOrEmpty(url));
        this.url = url;
        this.header = header;
    }

    public String getUrl() {
        return url;
    }

    public String getHeader() {
        return header;
    }
}
