package ru.yandex.direct.uaas;

import java.util.HashMap;
import java.util.Map;

import org.asynchttpclient.AsyncHttpClient;

import ru.yandex.direct.asynchttp.FetcherSettings;
import ru.yandex.direct.asynchttp.ParallelFetcherFactory;
import ru.yandex.direct.http.smart.converter.ResponseConverterFactory;
import ru.yandex.direct.http.smart.core.Call;
import ru.yandex.direct.http.smart.core.Smart;

import static ru.yandex.direct.http.smart.error.ErrorUtils.checkResultForErrors;

public class UaasClient {

    private UaasApi api;

    static final String DEFAULT_IP = "77.88.55.77";

    public UaasClient(UaasClientConfig uaasClientConfig, AsyncHttpClient asyncHttpClient) {
        var fetcherSettings = new FetcherSettings()
                .withConnectTimeout(uaasClientConfig.getConnectTimeout())
                .withRequestTimeout(uaasClientConfig.getRequestTimeout())
                .withRequestRetries(uaasClientConfig.getRequestRetries());

        var parallelFetcherFactory = new ParallelFetcherFactory(asyncHttpClient, fetcherSettings);
        this.api = Smart.builder()
                .withParallelFetcherFactory(parallelFetcherFactory)
                .withProfileName("uaas_api")
                .withBaseUrl(uaasClientConfig.getUrl())
                .addHeaderConfigurator(headers -> headers.add("Content-type", "application/json"))
                .withResponseConverterFactory(
                        ResponseConverterFactory.builder()
                                .addConverters(new UaasResponseParser())
                                .build()
                )
                .build()
                .create(UaasApi.class);
    }

    public UaasResponse split(UaasRequest uaasRequest) {
        Map<String, String> headerMap = new HashMap<>();
        if (uaasRequest.getUserAgent() != null) {
            headerMap.put("User-Agent", uaasRequest.getUserAgent());
        } else {
            headerMap.put("User-Agent", "");
        }
        if (uaasRequest.getCookies() != null) {
            headerMap.put("Cookie", uaasRequest.getCookies());
        }
        if (uaasRequest.getHost() != null) {
            headerMap.put("Host", uaasRequest.getHost());
        } else {
            headerMap.put("Host", "");
        }
        if (uaasRequest.getIp() != null) {
            headerMap.put("X-Forwarded-For-Y", uaasRequest.getIp());
        } else {
            headerMap.put("X-Forwarded-For-Y", DEFAULT_IP);
        }

        if (uaasRequest.getCuid() != null) {
            headerMap.put("X-Yandex-Cuid", uaasRequest.getCuid());
        }
        var text = uaasRequest.getText() != null ? uaasRequest.getText() : "";
        Call<UaasResponse> uaasResponseCall = api.split(uaasRequest.getService(), headerMap, text,
                uaasRequest.getUuid());
        var result = uaasResponseCall.execute();
        checkResultForErrors(result, UaasException::new);
        return result.getSuccess();
    }
}
