package ru.yandex.direct.uaas;

import java.time.Duration;
import java.util.Objects;

import javax.annotation.Nonnull;

public class UaasClientConfig {

    public static final String PRODUCTION_URL = "http://uaas.search.yandex.net";
    private static final UaasClientConfig DEFAULT = builder().build();
    private final String url;
    private final Duration connectTimeout;
    private final Duration requestTimeout;
    private final int requestRetries;

    private UaasClientConfig(String url, Duration connectTimeout, Duration requestTimeout, int requestRetries) {
        this.url = url;
        this.connectTimeout = connectTimeout;
        this.requestTimeout = requestTimeout;
        this.requestRetries = requestRetries;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static UaasClientConfig defaultConfig() {
        return DEFAULT;
    }

    @Nonnull
    public String getUrl() {
        return url;
    }

    @Nonnull
    public Duration getConnectTimeout() {
        return connectTimeout;
    }

    @Nonnull
    public Duration getRequestTimeout() {
        return requestTimeout;
    }

    @Nonnull
    public int getRequestRetries() {
        return requestRetries;
    }

    public static class Builder {
        private String url = PRODUCTION_URL;
        private Duration connectTimeout = Duration.ofMillis(300);
        private Duration timeout = Duration.ofMillis(1_000);
        private int requestRetries = 0;

        private Builder() {
        }

        public Builder withUrl(String url) {
            this.url = Objects.requireNonNull(url);
            return this;
        }

        public Builder withConnectTimeout(Duration connectTimeout) {
            this.connectTimeout = Objects.requireNonNull(connectTimeout);
            return this;
        }

        public Builder withTimeout(Duration timeout) {
            this.timeout = Objects.requireNonNull(timeout);
            return this;
        }

        public Builder withRequestRetries(int requestRetries) {
            this.requestRetries = requestRetries;
            return this;
        }

        public UaasClientConfig build() {
            return new UaasClientConfig(url, connectTimeout, timeout, requestRetries);
        }
    }

}
