package ru.yandex.direct.uaas;

import java.util.Objects;

public class UaasRequest {
    private final String service;
    private String ip;
    private String cookies;
    private String userAgent;
    private String text;
    private String host;
    private String uuid;
    private String cuid;

    public UaasRequest(String service) {
        this.service = service;
    }

    public String getService() {
        return service;
    }
    public String getIp() {
        return ip;
    }
    public UaasRequest withIp(String ip) {
        this.ip = ip;
        return this;
    }
    public String getCookies() {
        return cookies;
    }
    public UaasRequest withCookies(String cookies) {
        this.cookies = cookies;
        return this;
    }
    public String getUserAgent() {
        return userAgent;
    }
    public UaasRequest withUserAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }
    public String getText() {
        return text;
    }
    public UaasRequest withText(String text) {
        this.text = text;
        return this;
    }
    public String getHost() {
        return host;
    }
    public UaasRequest withHost(String host) {
        this.host = host;
        return this;
    }

    public String getUuid() {
        return uuid;
    }

    public UaasRequest withUuid(String uuid) {
        this.uuid = uuid;
        return this;
    }

    public String getCuid() {
        return cuid;
    }

    public UaasRequest withCuid(String cuid) {
        this.cuid = cuid;
        return this;
    }

    @Override
    public String toString() {
        return "UaasRequest{" +
                "service='" + service + '\'' +
                ", ip='" + ip + '\'' +
                ", cookies='" + cookies + '\'' +
                ", userAgent='" + userAgent + '\'' +
                ", text='" + text + '\'' +
                ", host='" + host + '\'' +
                ", uuid='" + uuid + '\'' +
                ", cuid='" + cuid + '\'' +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UaasRequest that = (UaasRequest) o;
        return Objects.equals(service, that.service) &&
                Objects.equals(ip, that.ip) &&
                Objects.equals(cookies, that.cookies) &&
                Objects.equals(userAgent, that.userAgent) &&
                Objects.equals(text, that.text) &&
                Objects.equals(host, that.host) &&
                Objects.equals(uuid, that.uuid) &&
                Objects.equals(cuid, that.cuid);
    }

    @Override
    public int hashCode() {
        return Objects.hash(service, ip, cookies, userAgent, text, host, uuid, cuid);
    }
}
