package ru.yandex.direct.uaas;

import java.lang.reflect.Type;

import io.netty.handler.codec.http.HttpHeaders;
import org.asynchttpclient.Response;

import ru.yandex.direct.http.smart.converter.ResponseConverter;

public class UaasResponseParser implements ResponseConverter<UaasResponse> {
    @Override
    public UaasResponse convert(Response response, Type responseType) {
        HttpHeaders headers = response.getHeaders();
        return UaasResponse.builder()
                .withConfigVersion(
                        headers.contains("X-Yandex-ExpConfigVersion") ? headers.get("X-Yandex-ExpConfigVersion") : "")
                .withSplitParamsEncoded(
                        headers.contains("X-Yandex-ExpSplitParams") ? headers.get("X-Yandex-ExpSplitParams") : "")
                .withBoxes(
                        headers.contains("X-Yandex-ExpBoxes") ? headers.get("X-Yandex-ExpBoxes") : "")
                .withBoxedCrypted(
                        headers.contains("X-Yandex-ExpBoxes-Crypted") ? headers.get("X-Yandex-ExpBoxes-Crypted") : "")
                .withFlagsEncoded(
                        headers.contains("X-Yandex-ExpFlags") ? headers.get("X-Yandex-ExpFlags") : "")
                .build();
    }

}
