package ru.yandex.direct.ugcdb.client;

import ru.yandex.direct.http.smart.annotations.ResponseHandler;
import ru.yandex.direct.http.smart.core.Call;
import ru.yandex.direct.http.smart.http.Body;
import ru.yandex.direct.http.smart.http.DELETE;
import ru.yandex.direct.http.smart.http.GET;
import ru.yandex.direct.http.smart.http.Headers;
import ru.yandex.direct.http.smart.http.PUT;
import ru.yandex.direct.http.smart.http.Path;
import ru.yandex.direct.http.smart.http.Query;
import ru.yandex.kernel.ugc.protos.direct.TDirectReview;
import ru.yandex.kernel.ugc.protos.direct.TDirectService;

interface Api {

    String MAIN_TABLE = "direct-service";
    String REVIEWS_TABLE = "reviews";
    String VERSION = "v1";
    String CONTENT_TYPE_HEADER = "Content-Type: application/json";

    @PUT(VERSION + "/" + MAIN_TABLE + "/{fl}/" + REVIEWS_TABLE + "/{fd}")
    @Headers(CONTENT_TYPE_HEADER)
    Call<Void> saveFeedback(@Path("fl") Long freelancerId, @Path("fd") String feedbackId, @Body
            UgcDbRequest review);

    @DELETE(VERSION + "/" + MAIN_TABLE + "/{fl}/" + REVIEWS_TABLE + "/{fd}")
    Call<Void> deleteFeedback(@Path("fl") Long freelancerId, @Path("fd") String feedbackId);

    @GET(VERSION + "/" + MAIN_TABLE + "/{fl}/" + REVIEWS_TABLE + "/{fd}")
    @ResponseHandler(parserClass = TDirectReviewConverter.class, expectedCodes = {200, 204})
    Call<TDirectReview> getFeedback(@Path("fl") Long freelancerId, @Path("fd") String feedbackId);

    @GET(VERSION + "/" + MAIN_TABLE + "/{fl}")
    @ResponseHandler(parserClass = TDirectServiceConverter.class, expectedCodes = {200, 204})
    Call<TDirectService> getFeedbackList(@Path("fl") Long freelancerId, @Query("yql_filter") String filter);
}
