package ru.yandex.direct.ugcdb.client;

import java.lang.reflect.Type;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.util.JsonFormat;
import org.asynchttpclient.Response;

import ru.yandex.direct.http.smart.converter.ResponseConverter;
import ru.yandex.kernel.ugc.protos.direct.TDirectReview;

public class TDirectReviewConverter implements ResponseConverter<TDirectReview> {
    private final JsonFormat.Parser parser = JsonFormat.parser();

    @Override
    public TDirectReview convert(Response response, Type responseType) {
        if (response.getStatusCode() == 204) {
            return null;
        }
        TDirectReview.Builder builder = TDirectReview.newBuilder();
        try {
            parser.merge(response.getResponseBody(), builder);
        } catch (InvalidProtocolBufferException e) {
            throw new UgcDbClientException("Cannot deserialize response", e);
        }
        return builder.build();
    }
}
