package ru.yandex.direct.ugcdb.client;

import java.lang.reflect.Type;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.util.JsonFormat;
import org.asynchttpclient.Response;

import ru.yandex.direct.http.smart.converter.ResponseConverter;
import ru.yandex.kernel.ugc.protos.direct.TDirectService;

public class TDirectServiceConverter implements ResponseConverter<TDirectService> {
    private final JsonFormat.Parser parser = JsonFormat.parser();

    @Override
    public TDirectService convert(Response response, Type responseType) {
        if (response.getStatusCode() == 204) {
            return TDirectService.getDefaultInstance();
        }
        TDirectService.Builder builder = TDirectService.newBuilder();
        try {
            parser.merge(response.getResponseBody(), builder);
        } catch (InvalidProtocolBufferException e) {
            throw new UgcDbClientException("Cannot deserialize response", e);
        }
        return builder.build();
    }
}
