package ru.yandex.direct.ugcdb.client;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;

public class UgcDbRequest {
    private final MessageOrBuilder message;
    private final JsonFormat.Printer printer = JsonFormat.printer().omittingInsignificantWhitespace();

    UgcDbRequest(MessageOrBuilder message) {
        this.message = message;
    }

    @Override
    public String toString() {
        try {
            return printer.print(message);
        } catch (InvalidProtocolBufferException e) {
            throw new UgcDbClientException("Cannot serialize request", e);
        }
    }
}
