package ru.yandex.direct.utils;

import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Optional;

/**
 * Этот класс облегчает написание AsyncConsumer-ов, открывая только безопасные методы для работы с каналом,
 * и при этом избаляет пользователя от необходимости думать об InterruptedException. В AsyncConsumer
 * прерывание - это всегда аварийное завершение (вызов cancel), так что можно запрограммировать обработку
 * прерываний прямо здесь.
 */
public class BlockingChannelReader<T> {
    private final BlockingChannel<T> channel;

    public BlockingChannelReader(BlockingChannel<T> channel) {
        this.channel = channel;
    }

    public List<T> takeAll() throws InterruptedException {
        return channel.takeAll();
    }

    public <C extends Collection<T>> C takeAllInto(C collection) throws InterruptedException {
        return channel.takeAllInto(collection);
    }

    public List<T> takeBatch(int size) throws InterruptedException {
        return channel.takeBatch(size);
    }

    public <C extends Collection<T>> C takeBatchInto(C collection, int size) throws InterruptedException {
        return channel.takeBatchInto(collection, size);
    }

    public Optional<T> poll() {
        return channel.poll();
    }

    public Optional<T> next() throws InterruptedException {
        return channel.next();
    }

    public void awaitClose(Duration timeout) throws InterruptedException {
        channel.awaitClose(timeout);
    }

    public boolean isClosed() {
        return channel.isClosed();
    }
}
