package ru.yandex.direct.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collector;

import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class Collectors {
    private Collectors() {
    }

    /**
     * В отличии от toMap():
     * - не кидает NPE на null key
     * - не кидает IllegalStatException на duplicate key, а перезапывает
     */
    public static <K, V> Collector<? super Map.Entry<? extends K, ? extends V>, Map<K, V>, Map<K, V>>
    nullFriendlyMapCollector() {
        return Collector.of(HashMap::new,
                (map, entry) -> map.put(entry.getKey(), entry.getValue()),
                (map1, map2) -> {
                    map1.putAll(map2);
                    return map1;
                });
    }
}
