package ru.yandex.direct.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;


/**
 * Простой наследник от {@link ObjectMapper}. Нужен, чтобы можно было сериализовать ({@link #writeValueAsString})
 * данные без перехвата {@link JsonProcessingException}
 */
public class DirectObjectMapper extends ObjectMapper {
    @Override
    public String writeValueAsString(Object value) {
        try {
            return super.writeValueAsString(value);
        } catch (JsonProcessingException e) {
            throw new IllegalArgumentException("can not serialize object to json", e);
        }
    }

    @Override
    public DirectObjectMapper registerModule(Module module) {
        return (DirectObjectMapper) super.registerModule(module);
    }
}
