package ru.yandex.direct.utils

import java.util.concurrent.CompletableFuture

object FutureUtils {

    @JvmStatic
    fun <T> complete(futures: List<CompletableFuture<T>>): CompletableFuture<List<T>> =
        CompletableFuture
            .allOf(*futures.toTypedArray())
            .thenApply { _ -> futures.map { it.join() } } // IGNORE-BAD-JOIN DIRECT-151604


    @JvmStatic
    fun <T> completeSafe(futures: List<CompletableFuture<T>>): CompletableFuture<List<Result<T>>> =
        complete(
            futures.map {
                it.handle { result, th ->
                    th?.let { Result.failure(it) } ?: Result.success(result)
                }
            }
        )

}
