package ru.yandex.direct.utils;

public class HostPort {
    private final String host;
    private final int port;

    public HostPort(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public static HostPort fromString(String hostPort) {
        String[] parts = hostPort.split(":");
        if (parts.length == 2) {
            return new HostPort(parts[0], Integer.parseInt(parts[1]));
        } else {
            throw new IllegalArgumentException("Expected string in form '<host>:<port>', got: " + hostPort);
        }
    }

    public String getHost() {
        return host;
    }

    public int getPort() {
        return port;
    }

    public HostPort withHost(String host) {
        return new HostPort(host, this.port);
    }

    @Override
    public String toString() {
        return host + ":" + port;
    }
}
