package ru.yandex.direct.utils;

import com.fasterxml.jackson.annotation.JsonCreator;

import static ru.yandex.direct.utils.JsonUtils.toJson;

/**
 * Обертка для JSON RPC 2.0 вызова, конвертирует его в JSON
 *
 * @param <T> тип параметров вызова
 */
public class JsonRpcRequest<T> {
    private String method;
    private T params;
    private Integer id;

    @JsonCreator
    public JsonRpcRequest() {
    }

    /**
     * Создает объект JSON RPC 2.0 вызова
     *
     * @param method вызываемый метод
     * @param params параметры вызова
     * @param id     идентификатор вызова
     */
    public JsonRpcRequest(String method, T params, Integer id) {
        this.method = method;
        this.params = params;
        this.id = id;
    }

    /**
     * Возвращает служебное поле версии JSON RPC
     *
     * @return "2.0"
     */
    public String getJsonrpc() {
        return "2.0";
    }

    /**
     * Возвращает вызываемый метод
     *
     * @return
     */
    public String getMethod() {
        return method;
    }

    /**
     * Возвращает параметры вызова
     *
     * @return
     */
    public Object getParams() {
        return params;
    }

    /**
     * Возвращает идентификатор вызова
     *
     * @return
     */
    public Integer getId() {
        return id;
    }

    /**
     * Возвращает сформированный JSON для вызова
     *
     * @return
     */
    @Override
    public String toString() {
        return toJson(this);
    }
}
