package ru.yandex.direct.utils;

/**
 * Обертка над JSON RPC 2.0 ответом, десериализуется из JSON
 *
 * @param <T> тип результата
 */
public class JsonRpcResponse<T> {
    private int id;
    private String jsonrpc;
    private T result;
    private JsonRpcError error;

    public JsonRpcResponse() {
    }

    public JsonRpcResponse(int id, T result) {
        this.id = id;
        this.jsonrpc = "2.0";
        this.result = result;
    }

    /**
     * @return идентификатор запроса
     */
    public int getId() {
        return id;
    }

    /**
     * @param value идентификатор запроса
     */
    public void setId(int value) {
        id = value;
    }

    /**
     * @return версия JSON RPC, должно быть "2.0"
     */
    public String getJsonrpc() {
        return jsonrpc;
    }

    /**
     * @param value версия JSON RPC, должно быть "2.0"
     */
    public void setJsonrpc(String value) {
        jsonrpc = value;
    }

    /**
     * @return объект результата
     */
    public T getResult() {
        return result;
    }

    /**
     * @param value объект результата
     */
    public void setResult(T value) {
        result = value;
    }

    /**
     * @return объект ошибки
     */
    public JsonRpcError getError() {
        return error;
    }

    /**
     * @param value объект ошибки
     */
    public void setError(JsonRpcError value) {
        error = value;
    }

}
