package ru.yandex.direct.utils;

import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.function.Function;

/**
 * Очередь, хранящая элементы в LinkedHashMap. Сами элементы запысываются в мэп как значения, ключ для них
 * вычисляется с использованием переданной функции getKey.
 *
 * @param <K> тип ключа
 * @param <T> тип элементов очереди
 */
public class LinkedHashMapQueue<K, T> extends AbstractQueue<T> {
    private final LinkedHashMap<K, T> map;
    private final Function<T, K> getKey;

    public LinkedHashMapQueue(Function<T, K> getKey) {
        this.map = new LinkedHashMap<>();
        this.getKey = getKey;
    }

    @Override
    public Iterator<T> iterator() {
        return map.values().iterator();
    }

    @Override
    public boolean offer(T t) {
        map.put(getKey.apply(t), t);
        return true;
    }

    @Override
    public T poll() {
        return map.isEmpty() ? null : map.remove(map.keySet().iterator().next());
    }

    @Override
    public T peek() {
        return map.isEmpty() ? null : iterator().next();
    }

    @Override
    public int size() {
        return map.size();
    }

    @Override
    public void clear() {
        map.clear();
    }

    public Collection<T> values() {
        return map.values();
    }

    public void dropKey(K key) {
        map.remove(key);
    }
}
