package ru.yandex.direct.utils;

import java.time.Duration;

/**
 * Правильный способ замерять время между событиями в программе - это System.nanoTime(),
 * остальные способы из стандартной библиотеки не подходят, потому что на их показаниях отражается
 * изменение системного времени, а системное время может меняться по многим причинам: админы могут перевести
 * часы вручную, ntpd может менять время, может меняться часовой пояс, может случится переход на летнее время.
 * <p>
 * Такие баги с замером времени трудно отлаживать и отлавливать.
 * <p>
 * MonotonicClock - это абстракция над System.nanoTime(), которая вносит более строгую типизацию, дает возможность
 * не париться единицами измерения времени и позволяет мокать время в тестах.
 */
public interface MonotonicClock {
    /**
     * @return текущее время
     */
    MonotonicTime getTime();

    void sleep(Duration duration) throws InterruptedException;

    default void sleepUninterruptibly(Duration duration) {
        Interrupts.waitUninterruptibly(duration, d -> {
            sleep(d);
            return false;
        }, this);
    }
}
