package ru.yandex.direct.utils;

public class MySQLQuote {
    private MySQLQuote() {
    }

    /**
     * Квотирует идентификатор как это делает mysqldump, для использования напрямую в sql.
     */
    public static String quoteName(String name) {
        StringBuilder sb = new StringBuilder(name.length() + 2);
        sb.append('`');
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (ch == '`') {
                sb.append(ch);
            }
            sb.append(ch);
        }
        sb.append('`');
        return sb.toString();
    }

    /**
     * Квотирует идентификатор как это делает mysqldump, для использования напрямую в sql в качестве выражения для like.
     */
    public static String quoteLike(String name) {
        StringBuilder sb = new StringBuilder(name.length() + 2);
        sb.append('\'');
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            switch (ch) {
                case '\\':
                    sb.append('\\');
                    sb.append('\\');
                    sb.append('\\');
                    break;
                case '\'':
                case '_':
                case '%':
                    sb.append('\\');
                    break;
                default:
                    //pass
            }
            sb.append(ch);
        }
        sb.append('\'');
        return sb.toString();
    }
}
