package ru.yandex.direct.utils;

import static com.google.common.base.Preconditions.checkNotNull;
import static com.google.common.base.Preconditions.checkState;

public class NumbersCheckUtils {
    private NumbersCheckUtils() {
    }

    public static int checkInsideBounds(Integer num, int lowerBound, int upperBound) {
        checkNotNull(num, "Expected that number is not null");
        checkInsideBounds(num.longValue(), (long) lowerBound, (long) upperBound);
        return num;
    }

    public static long checkInsideBounds(Long num, long lowerBound, long upperBound) {
        checkNotNull(num, "Expected that number is not null");
        checkState(lowerBound <= upperBound, "Expected that lower bound is less or equal then upper one");
        checkState(num >= lowerBound && num <= upperBound, "Expected that %s is between %s and %s", num, lowerBound,
                upperBound);
        return num;
    }

    public static long checkIsValidId(Long id) {
        return checkInsideBounds(id, 1, Long.MAX_VALUE);
    }
}
