package ru.yandex.direct.utils;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;

/**
 * Utility class for logic around Yandex.Passport
 */
@ParametersAreNonnullByDefault
public class PassportUtils {
    private PassportUtils() {
    }

    /**
     * Normalize login:
     * - strip whitespaces
     * - lowercase
     * - replace "." to "-" (not for lite-logins)
     */
    @Nonnull
    public static String normalizeLogin(String login) {
        String result = StringUtils.strip(login);
        result = result.toLowerCase();
        if (!result.contains("@")) {
            // not lite login
            result = StringUtils.replaceChars(result, '.', '-');
        }
        return result;
    }

    /**
     * Сгенерировать случайный пароль из латинских букв и цифр заданной длины
     *
     * @param size Кол-во символов в пароле
     */
    @Nonnull
    public static String generateRandomPassword(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("size: " + size);
        }
        return RandomStringUtils.random(size, true, true);
    }
}
