package ru.yandex.direct.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;

public class SetsDiff<T> {
    private final List<T> leftMissed;
    private final List<T> rightMissed;
    private final int equalsElementsCount;

    public SetsDiff(List<T> leftMissed, List<T> rightMissed, int equalsElementsCount) {
        this.leftMissed = leftMissed;
        this.rightMissed = rightMissed;
        this.equalsElementsCount = equalsElementsCount;
    }

    public boolean isEmpty() {
        return leftMissed.isEmpty() && rightMissed.isEmpty();
    }

    public static <T> SetsDiff<T> createDiff(Set<T> leftSet, Set<T> rightSet, Comparator<T> comparator) {
        if (leftSet == null) {
            leftSet = Collections.emptySet();
        }
        if (rightSet == null) {
            rightSet = Collections.emptySet();
        }
        int equalsElementsCount = 0;
        List<T> leftMissed = new ArrayList<>();
        for (T element: leftSet) {
            if (!rightSet.contains(element)) {
                leftMissed.add(element);
            } else {
                equalsElementsCount++;
            }
        }
        List<T> rightMissed = new ArrayList<>();
        for (T element: rightSet) {
            if (!leftSet.contains(element)) {
                rightMissed.add(element);
            }
        }
        if (comparator != null) {
            leftMissed.sort(comparator);
            rightMissed.sort(comparator);
        }
        return new SetsDiff<>(leftMissed, rightMissed, equalsElementsCount);
    }

    public List<T> getLeftMissed() {
        return leftMissed;
    }

    public List<T> getRightMissed() {
        return rightMissed;
    }

    public int getEqualsElementsCount() {
        return equalsElementsCount;
    }

    @Override
    public String toString() {
        if (isEmpty()) {
            return "All " + equalsElementsCount + " elements in sets are the same";
        }
        StringBuilder diff = new StringBuilder();
        if (!leftMissed.isEmpty()) {
            diff.append(String.format("left missed elements: %s, ", leftMissed));
        } else {
            diff.append("left missed elements not found, ");
        }
        if (!rightMissed.isEmpty()) {
            diff.append(String.format("right missed elements: %s, ", rightMissed));
        } else {
            diff.append("right missed elements not found, ");
        }
        diff.append(String.format("equals elements count: %d", equalsElementsCount));
        return diff.toString();
    }
}
