package ru.yandex.direct.utils;

import static ru.yandex.direct.utils.StringUtils.getAllDistinctChars;

/**
 * Класс допустимых символов и ограничений общего назначения.
 * <p>
 * Языки: http://www.omniglot.com/writing/
 */
public class TextConstants {

    // Cyrillic
    public static final String RUS_ALPHABET = "абвгдеёжзийклмнопрстуфхцчшщъыьэюяАБВГДЕЁЖЗИЙКЛМНОПРСТУФХЦЧШЩЪЫЬЭЮЯ";
    public static final String UKR_ALPHABET = "абвгґдеєжзиіїйклмнопрстуфхцчшщьюяАБВГҐДЕЄЖЗИІЇЙКЛМНОПРСТУФХЦЧШЩЬЮЯ";
    public static final String BEL_ALPHABET = "абвгдеёжзійклмнопрстуўфхцчшыьэюяАБВГДЕЁЖЗІЙКЛМНОПРСТУЎФХЦЧШЫЬЭЮЯ";
    public static final String KAZ_ALPHABET =
            "аәбвгғдеёжзийкқлмнңоөпрстуұүфхһцчшщъыіьэюяАӘБВГҒДЕЁЖЗИЙКҚЛМНҢОӨПРСТУҰҮФХҺЦЧШЩЪЫІЬЭЮЯ";
    public static final String UZB_CYRILLIC_ALPHABET =
            "абвгдеёжзийклмнопрстуфхцчшъьэюяўқғҳАБВГДЕЁЖЗИЙКЛМНОПРСТУФХЦЧШЪЬЭЮЯЎҚҒҲʼ";

    // Latin
    public static final String ENG_ALPHABET = "abcdefghijklmonpqrstuvwxyzABCDEFGHIJKLMONPQRSTUVWXYZ";
    public static final String GER_ALPHABET = "abcdefghijklmonpqrstuvwxyzäöüßABCDEFGHIJKLMONPQRSTUVWXYZÄÖÜẞ";
    public static final String TUR_ALPHABET = "abcçdefgğhıijklmnoöprsştuüvyzABCÇDEFGĞHIİJKLMNOÖPRSŞTUÜVYŻâÂîÎûÛ";
    public static final String EST_ALPHABET = "abcdefghijklmnopqrsšzžtuvwõäöüxyABCDEFGHIJKLMNOPQRSŠZŽTUVWÕÄÖÜXY";
    public static final String LAV_ALPHABET = "aābcčdeēfgģhiījkķlļmnņoprsštuūvzžAĀBCČDEĒFGĢHIĪJKĶLĻMNŅOPRSŠTUŪVZŽ";
    public static final String LIT_ALPHABET = "aąbcčdeęėfghiįyjklmnoprsštuųūvzžAĄBCČDEĘĖFGHIĮYJKLMNOPRSŠTUŲŪVZŽ";
    // Версия алфавита 1995 года
    public static final String UZB_LATIN_ALPHABET = "abcdefghijklmnopqrstuvxyzABCDEFGHIJKLMNOPQRSTUVXYZʻʼ";
    public static final String VIE_ALPHABET = "aáàảãạăắằẳẵặâấầẩẫậbcdđeéèẻẽẹêếềểễệghiíìỉĩịklmnoóòỏõọôốồổỗộơớờởỡợpqrstu" +
            "úùủũụưứừửữựvxyýỳỷỹỵAÁÀẢÃẠĂẮẰẲẴẶÂẤẦẨẪẬBCDĐEÉÈẺẼẸÊẾỀỂỄỆGHIÍÌỈĨỊKLMNOÓÒỎÕỌÔỐỒỔỖỘƠỚỜỞỠỢPQRSTUÚÙỦŨỤƯỨỪỬỮỰVXY" +
            "ÝỲỶỸỴ";
    public static final String SPA_ALPHABET = ENG_ALPHABET + "áéíñóúÁÉÍÑÓÚ";
    public static final String POR_ALPHABET = ENG_ALPHABET + "áàâãéèêíïóôõöúçñÁÀÂÃÉÈÊÍÏÓÔÕÖÚÇÑ";
    public static final String CZE_ALPHABET = ENG_ALPHABET + "áčďéěíňóřšťúůýžÁČĎÉĚÍŇÓŘŠŤÚŮÝŽ";
    public static final String POL_ALPHABET = ENG_ALPHABET + "ąćęłńóśźżĄĆĘŁŃÓŚŹŻ";

    /**
     * Латинские буквы
     */
    public static final String LAT_LETTERS = "abcdefghijklmonpqrstuvwxyzABCDEFGHIJKLMONPQRSTUVWXYZ";

    /**
     * Русские буквы
     */
    public static final String RUS_LETTERS = "абвгдеёжзийклмнопрстуфхцчшщъыьэюяАБВГДЕЁЖЗИЙКЛМНОПРСТУФХЦЧШЩЪЫЬЭЮЯ";

    /**
     * Казахские буквы (кроме совпадающих с русскими)
     */
    public static final String KAZ_LETTERS = "ҰҒғӨҢҚҺҮұөңқһүҖҲҳҗӘә";

    /**
     * Украинские буквы (кроме совпадающих с русскими и белорусскими)
     */
    public static final String UKR_LETTERS = "ЄЇєїҐґ";

    /**
     * Белорусские буквы (кроме совпадающих с русскими и украинскими)
     */
    public static final String BEL_LETTERS = "Ўў";

    public static final String COMMON_UKR_BEL_LETTERS = "Іі"; // <- кириллические і

    /**
     * Общие символы турецкого и немецких алфавитов
     */
    public static final String GENERAL_TR_DE_LETTERS = "üÜöÖ";

    /**
     * Уникальные символы турецкого алфавита, не входящие в немецкий и другие описанные допустимые языки
     */
    public static final String UNIQUE_TR_LETTERS = "ğĞşŞçÇıİ̇âÂîÎûÛé";

    /**
     * Турецкие буквы (кроме совпадающих с латинскими)
     */
    public static final String TR_LETTERS = GENERAL_TR_DE_LETTERS + UNIQUE_TR_LETTERS;

    /**
     * Уникальные символы немецкого алфавита, не входящие в турецкий и другие описанные допустимые языки
     */
    public static final String UNIQUE_DE_LETTERS = "Ääßẞ";

    /**
     * Немецкие буквы (кроме совпадающих с латинскими и турецкими)
     */
    public static final String DE_LETTERS = GENERAL_TR_DE_LETTERS + UNIQUE_DE_LETTERS;

    /**
     * Цифры
     */
    public static final String NUMBERS = "0123456789";

    /**
     * символы пунктуации
     */
    public static final String PUNCTUATION = "[]-+,.\"¡!¿?\\()%$€;:/&'*_=#№«»–—−";

    /**
     * Пробельные символы
     */
    public static final String SPACE_CHARS = " \u00a0";

    /**
     * Специальные символы
     */
    public static final String SPECIAL_CHARS = "™®©’°⁰¹²³⁴⁵⁶⁷⁸⁹\u20bd";

    /**
     * Символы всех поддерживаемых алфавитов
     */
    public static final String LETTERS = getAllDistinctChars(RUS_ALPHABET, UKR_ALPHABET, BEL_ALPHABET, KAZ_ALPHABET,
            UZB_CYRILLIC_ALPHABET, ENG_ALPHABET, GER_ALPHABET, TUR_ALPHABET, UZB_LATIN_ALPHABET, VIE_ALPHABET,
            SPA_ALPHABET, POR_ALPHABET, CZE_ALPHABET, POL_ALPHABET);

    /**
     * Символы и цифры
     */
    public static final String LETTERS_AND_NUMBERS = LETTERS + NUMBERS;

    /**
     * все допустимые символы
     */
    public static final String ALL = LETTERS_AND_NUMBERS + PUNCTUATION + SPACE_CHARS;

    private TextConstants() {
    }
}
