package ru.yandex.direct.utils;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;

import com.univocity.parsers.common.processor.BeanListProcessor;
import com.univocity.parsers.tsv.TsvParser;
import com.univocity.parsers.tsv.TsvParserSettings;

/**
 * Утилитные методы для парсинга tsv данных
 *
 * @see TsvParser
 */
public abstract class TsvParserUtils {

    /**
     * Получить список объектов из tsv
     *
     * @param data       tsv данные
     * @param beansClass класс объекта в который надо преобразовать данные
     * @return список объектов
     */
    public static <T> List<T> getBeansList(InputStream data, Class<T> beansClass) {
        BeanListProcessor<T> rowProcessor = new BeanListProcessor<>(beansClass);
        rowProcessor.setStrictHeaderValidationEnabled(true);

        TsvParserSettings parserSettings = new TsvParserSettings();
        parserSettings.setLineSeparatorDetectionEnabled(true);
        parserSettings.setProcessor(rowProcessor);
        parserSettings.setHeaderExtractionEnabled(true);
        TsvParser parser = new TsvParser(parserSettings);

        parser.parse(data);
        return rowProcessor.getBeans();
    }

    /**
     * Получить список объектов из tsv
     *
     * @see #getBeansList
     */
    public static <T> List<T> getBeansList(byte[] data, Class<T> beansClass) {
        return getBeansList(new ByteArrayInputStream(data), beansClass);
    }

}
