package ru.yandex.direct.utils;

import java.io.IOException;
import java.time.LocalDate;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;

/**
 * Десериализует дату вида "0000-00-00" значением null. Десериализация других значений делегируется в
 * {@link JsonParser#readValueAs(Class)}
 */
public class ZeroDateAwareDeserializer extends StdScalarDeserializer<LocalDate> {
    public static final String ZERO_DATE_STRING = "0000-00-00";

    protected ZeroDateAwareDeserializer() {
        super(LocalDate.class);
    }

    @Override
    public LocalDate deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonToken t = p.getCurrentToken();
        if (t == JsonToken.VALUE_STRING && ZERO_DATE_STRING.equals(p.getText().trim())) {
            return getNullValue(ctxt);
        }
        return p.readValueAs(LocalDate.class);
    }
}
