package ru.yandex.direct.utils.collectors;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Stream;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * Переворачивает Map<K, Set<V> в Map<V, Set<K>>. Берет все уникальные значения всех сетов и отображает каждое
 * значение в сет ключей по которым можно было найти сет с этим значением.
 * @param <K>
 * @param <V>
 */
@ParametersAreNonnullByDefault
public final class FlipMapCollector<K, V> implements Collector<Map.Entry<K, Set<V>>, Map<V, Set<K>>, Map<V, Set<K>>> {
    @Override
    public Supplier<Map<V, Set<K>>> supplier() {
        return HashMap::new;
    }

    @Override
    public BiConsumer<Map<V, Set<K>>, Map.Entry<K, Set<V>>> accumulator() {
        return (acc, next) -> {
            for (var item : next.getValue()) {
                final var accSet = acc.getOrDefault(item, new HashSet<>());

                accSet.add(next.getKey());
                acc.put(item, accSet);
            }
        };
    }

    @Override
    public BinaryOperator<Map<V, Set<K>>> combiner() {
        return (acc1, acc2) -> Stream.of(acc1, acc2).collect(new MergeMapCollector<>());
    }

    @Override
    public Function<Map<V, Set<K>>, Map<V, Set<K>>> finisher() {
        return acc -> acc;
    }

    @Override
    public Set<Characteristics> characteristics() {
        return Set.of(Characteristics.UNORDERED);
    }
}
