package ru.yandex.direct.utils.compress;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

import org.apache.commons.io.IOUtils;

import ru.yandex.direct.utils.io.RuntimeIoException;

/**
 * Компрессия/декомпрессия данных алгоритмом gzip
 */
public class GzipUtils {
    private GzipUtils() {
    }

    public static byte[] compressString(String data) {
        return compress(data.getBytes(StandardCharsets.UTF_8));
    }

    public static String decompressString(byte[] data) {
        return new String(decompress(data), StandardCharsets.UTF_8);
    }

    public static byte[] compress(byte[] data) {
        try (
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                GZIPOutputStream gzip = new GZIPOutputStream(bos);
        ) {
            gzip.write(data);
            gzip.finish();
            return bos.toByteArray();
        } catch (IOException e) {
            throw new RuntimeIoException("Can't compress data", e);
        }
    }

    public static byte[] decompress(byte[] compressed) {
        try (
                ByteArrayInputStream bis = new ByteArrayInputStream(compressed);
                GZIPInputStream gis = new GZIPInputStream(bis);
        ) {
            return IOUtils.toByteArray(gis);
        } catch (IOException e) {
            throw new RuntimeIoException("Can't decompress data", e);
        }
    }

}
