package ru.yandex.direct.utils.compress;

import java.nio.charset.StandardCharsets;

import net.jpountz.lz4.LZ4CompressorWithLength;
import net.jpountz.lz4.LZ4DecompressorWithLength;
import net.jpountz.lz4.LZ4Factory;

/**
 * Компрессия/декомпрессия данных алгоритмом lz4
 */
public class LZ4Utils {
    private static LZ4Factory lz4Factory = LZ4Factory.fastestInstance();

    private LZ4Utils() {
    }

    public static byte[] compressString(String data) {
        return compress(data.getBytes(StandardCharsets.UTF_8));
    }

    public static String decompressString(byte[] data) {
        return new String(decompress(data), StandardCharsets.UTF_8);
    }

    public static byte[] compress(byte[] data) {
        var compressor = new LZ4CompressorWithLength(lz4Factory.fastCompressor());
        return compressor.compress(data);
    }

    public static byte[] decompress(byte[] compressed) {
        var decompressor = new LZ4DecompressorWithLength(lz4Factory.fastDecompressor());
        return decompressor.decompress(compressed);
    }
}
