package ru.yandex.direct.utils.hostname;

public class CachedHostnameResolver implements HostnameResolver {
    private final HostnameResolver resolver;
    private boolean cached;
    private String errorMessage;
    private String hostname;

    public CachedHostnameResolver(HostnameResolver resolver) {
        this.resolver = resolver;
        this.cached = false;
        this.errorMessage = null;
        this.hostname = null;
    }

    @Override
    public synchronized String getHostname() {
        if (!cached) {
            try {
                hostname = resolver.getHostname();
                cached = true;
            } catch (HostnameResolvingException exc) {
                errorMessage = exc.getMessage();
                cached = true;
                throw exc;
            }
        }
        if (hostname == null) {
            throw new HostnameResolvingException(errorMessage);
        } else {
            return hostname;
        }
    }
}
