package ru.yandex.direct.utils.hostname;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FallbackHostnameResolver implements HostnameResolver {
    private static final Logger logger = LoggerFactory.getLogger(FallbackHostnameResolver.class);

    private final HostnameResolver resolver;
    private final String fallback;
    private boolean firstRun;

    public FallbackHostnameResolver(HostnameResolver resolver, String fallback) {
        this.resolver = resolver;
        this.fallback = fallback;
        this.firstRun = true;
    }

    @Override
    public synchronized String getHostname() {
        try {
            return resolver.getHostname();
        } catch (HostnameResolvingException exc) {
            if (firstRun) {
                firstRun = false;
                logger.warn("Failed to resolve current hostname, will use " + fallback, exc);
            }
            return fallback;
        }
    }
}
