package ru.yandex.direct.utils.hostname;

import java.net.InetAddress;
import java.net.UnknownHostException;

import org.apache.commons.lang3.StringUtils;

public class SimpleHostnameResolver implements HostnameResolver {
    // Переменная окружения, которая в Деплое хранит fqdn хоста-контейнера
    private static final String DEPLOY_POD_PERSISTENT_FQDN = "DEPLOY_POD_PERSISTENT_FQDN";

    @Override
    public String getHostname() {
        try {
            // Сначала пробуем получить имя хоста из переменной окружения
            // Это более надёжно: если пытаться отрезолвить DNS самостоятельно, то
            // при неудаче неверно разрезолвленный хостнейм может ещё и закешироваться.
            // Далее juggler client будет слать события для неправильного хоста,
            // и у нас могут не по делу загореться проверки из-за отсутствия событий по нужным хостам
            String persistentFQDN = System.getenv(DEPLOY_POD_PERSISTENT_FQDN);
            if (StringUtils.isNotBlank(persistentFQDN)) {
                return persistentFQDN;
            }

            // We call toLowerCase as a workaround for DNS servers that cache domain names with whatever case
            // it was in the query. It has been known to return names like YaNDEX.net on OpenStack.
            return InetAddress.getLocalHost().getCanonicalHostName().toLowerCase();
        } catch (UnknownHostException exc) {
            throw new HostnameResolvingException(exc.getMessage(), exc);
        }
    }
}
