package ru.yandex.direct.utils.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;

import javax.annotation.Nonnull;

import org.apache.commons.io.IOUtils;

public class ResourceUtils {
    private ResourceUtils() {
    }

    /**
     * Прочитать байтики ресурса
     */
    @Nonnull
    public static byte[] readResourceBytes(@Nonnull String resourcePath) {
        Objects.requireNonNull(resourcePath);
        try (InputStream is = ResourceUtils.class.getClassLoader().getResourceAsStream(resourcePath)) {
            if (is == null) {
                throw new IllegalStateException("Resource not found: " + resourcePath);
            }
            return IOUtils.toByteArray(is);
        } catch (IOException e) {
            throw new RuntimeIoException("Can't read resource " + resourcePath, e);
        }
    }
}
